#!/bin/sh
# /opt/Mahr/ps10/mass_storage.sh
set -x
FILE=""
CURRENT_GADGET_MODE=/tmp/current_gadget_mode
GADGET=$(cat ${CURRENT_GADGET_MODE})
#echo GADGET=${GADGET}
if [ "_${GADGET}" != "_configfs" ]; then
	FILE=/sys/devices/platform/ocp/47400000.usb/47401400.usb/musb-hdrc.0/gadget/lun0/file
else
	FILE=/sys/kernel/config/usb_gadget/g1/functions/mass_storage.0/lun.0/file
fi
#echo FILE=${FILE}

BS=/tmp/bs.vfat
BSFILE=/tmp/bs.file
MP=/media/backing
FLASH=/var/opt/Mahr/ps10/results

if [ ! -e ${BS} ]; then
        echo "mass_storage.sh: ${BS} does not exist. Abort."
        exit 1
fi

if [ "_$1" == "_on" ]; then
  df | grep /dev/loop
  if [ $? -eq 0 ]; then
    rsync -av --delete --exclude=windows_driver_files ${FLASH}/ ${MP}/
	  sync
  fi

	umount ${MP} > /dev/null 2>&1
	echo ${BS} > ${FILE}
	echo ${FILE} > ${BSFILE}
elif [ "_$1" == "_off" ]; then
	rm -f ${BSFILE}
        echo "" > ${FILE}
	mkdir -p ${MP}
    grep /media/backing /proc/mounts >/dev/null 2>&1
    if [ $? != 0 ]; then
        mount -t vfat -o loop ${BS} ${MP} || exit 1
        rsync -av --delete --exclude=windows_driver_files ${MP}/ ${FLASH}/
    fi
	sync
else
	echo "usage $0 <on|off>"
fi
